
*****************************************************************************************
***     ANALYSIS: "Stable relationships, stable participation?"			      		  ***
***		DATA:  - Pairfam waves 1 to 6, Release 6.0	 							      ***
***			   - Paradata waves 3 to 7 (available upon request) 				      ***
***																				      ***	
*** 	CONTENT: Data preparation 												      ***
***		   	   - Pooled data set											   	      ***
***		       - Dependent variables participation, contact, cooperation      	      ***
***		       - Explanatory variables 											   	  ***
***		       - Analysis sample: Two consecutive observations & partner in wave t-2  ***	
***		       - Explanatory variables for analyses based on restricted sample	  	  ***
*****************************************************************************************

clear all
set maxvar 10000
set more off
set varabbrev off

global path1 `""datapath""'  
global path2 `""syntaxpath""'    


** Data preparation: additional variables and paradata
cd $path2	
do "0 DataPrep.do"

	
*******************************
*** 	Pooled Data Set  	***
*******************************	

cd $path1

** WAVE 1 

* Use anchor data set wave 1 for lagged explanatory variables 
	use anchor1p.dta, clear nolabel
	keep id pid wave cohort sd3 age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus sat5 sex5 hhincnet pct_inr* nbitems enrol ///
			pa26 pa27 pa28 np reldur cob hc5h1
	
	* Partner status
	gen hp=0
	replace hp=1 if sd3==1
	tab hp sd3, m
	drop sd3
		
	gen hpsep=0
	
	gen waveb=1
	
	save "wave1.dta", replace		


** WAVES 2/3 

* Merge anchor data set wave 2 and paradata on reasons for non-participation in wave 3
	use bruttoband_Welle3red.dta, clear							
	merge 1:1 id using anchor2p.dta, keepusing (id pid wave cohort age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus sat5 sex5 hhincnet ///
												pct_inr* nbitems enrol pa26 pa27 pa28 np reldur cob hc5h1 moves ehcid ehc2p* ehc6p* sep12 sep2) nol								
	
	drop if _merge==1											// drop temporary dropouts wave 2			
	drop if _merge==2 											// drop respondents who withdrew permission to be re-contacted 		
	drop _merge
	
	** Dependent variables
	
	* Contact 
	gen pcontact=erg
	recode pcontact 1 3 5 7 13=0 	6 8 9 10 11 12 15 17 	33=1
	tab pcontact, m

	* Cooperation
	gen pcoop=erg
	recode pcoop 1 3 5 7 13=.	 	6 8 9 10 11 12 15 17=0 	33=1
	tab pcoop, m
	
	* Participation
	gen presponse=erg
	recode presponse 33=1 else=0
	tab presponse, m
	
	// generate variable on separation according to question program (ehc2p1m(ehcid)=1 & ehc2p1=0 & ehc6p1!=1)	
	gen hpsep=0
		forvalues m=1/18{
			replace hpsep=1 if `m'==ehcid & ehc2p1m`m'==1 & ehc2p1==0 & ehc6p1!=1
			}
	
	* Partner Status
	gen hp=0
	forvalues x=1/5{
		replace hp=1 if ehc2p`x'==1 
	}
	tab hp, m
	tab sep12 hpsep, m
	
	gen waveb=3				
	
	save "wave3.dta", replace		


** WAVES 3/4 

* Merge anchor data set wave 3 and paradata on reasons for non-participation in wave 4
	use bruttoband_Welle4red.dta, clear									
	merge 1:1 id using anchor3p.dta, keepusing (id pid wave hp hpsep cohort age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus pct_inr* nbitems  ///
												sat5 sex5 hhincnet enrol pa26 pa27 pa28 np reldur cob hc5h1 moves sep2) nol							
	
	drop if _merge==1											// drop temporary dropouts wave 3		
	drop if _merge==2 											// drop respondents who withdrew permission to be re-contacted 
	
	drop _merge
	
	
	** Dependent variables
	
	* Contact 
	gen pcontact=erg
	recode pcontact 1 3 5 7 13=0 	6 8 9 10 11 12 15 17 	33=1
	tab pcontact, m

	* Cooperation
	gen pcoop=erg
	recode pcoop 1 3 5 7 13=. 	6 8 9 10 11 12 15 17=0 	33=1
	tab pcoop, m	
	
	* Participation
	gen presponse=erg
	recode presponse 33=1 else=0
	tab presponse, m

	gen waveb=4
	
	save "wave4.dta", replace		


** WAVES 4/5 

 * Merge anchor data set wave 4 and paradata on reasons for non-participation in wave 5
	use bruttoband_Welle5red.dta, clear										
	merge 1:1 id using anchor4p.dta, keepusing (id pid wave hp hpsep cohort age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus pct_inr* ///
												nbitems sat5 sex5 hhincnet enrol pa26 pa27 pa28 np reldur cob hc5h1 moves sep2) nol
								
	drop if _merge==1														// drop temporary dropouts wave 4					
	drop if _merge==2														// drop respondents who withdrew permission to be re-contacted 
	drop _merge
	
	** Dependent variables
	
	* Contact
	gen pcontact=erg									
	recode pcontact 1 2 3 13 14 =0 		4 5 7 8 9 10 11 12 15 17 	33=1	
	tab pcontact, m

	* Cooperation
	gen pcoop=erg
	recode pcoop 1 2 3 13 14=. 		4 5 7 8 9 10 11 12 15 17=0 	33=1 	
	tab pcoop, m
	
	* Participation
	gen presponse=erg
	recode presponse 33=1 else=0
	tab presponse, m
	
	gen waveb=5
	
	save "wave5.dta", replace	
	
	
** WAVES 5/6 

 * Merge anchor data set wave 5 and paradata on reasons for non-participation in wave 6
	use bruttoband_Welle6red.dta, clear									
	merge 1:1 id using anchor5p.dta, keepusing (id pid wave hp hpsep cohort age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus pct_inr* nbitems  ///
												sat5 sex5 hhincnet enrol pa26 pa27 pa28 np reldur cob hc5h1 moves sep2) nol											
	
	drop if _merge==1														// drop temporary dropouts wave 5											
	drop if _merge==2														// drop respondents who withdrew permission to be re-contacted 
	drop _merge
	
	** Dependent variables
	
	* Contact
	gen pcontact=erg									
	recode pcontact 1 2 3 13 14 =0 	4 5 7 8 9 10 11 12 15 17 	33=1	
	tab pcontact, m

	* Cooperation
	gen pcoop=erg
	recode pcoop 1 2 3 13 14=. 	4 5 7 8 9 10 11 12 15 17=0 	33=1 	
	tab pcoop, m
	
	* Participation
	gen presponse=erg
	recode presponse 33=1 else=0
	tab presponse, m
	
	gen waveb=6
	
	save "wave6.dta", replace	
	
	
*** WAVES 6/7 	

 * Merge anchor data set wave 6 and paradata on reasons for non-participation in wave 7
	use bruttoband_Welle7red.dta, clear									
	merge 1:1 id using anchor6p.dta, keepusing (id pid wave hp hpsep cohort age sex_gen yeduc isced2 lfs relstat nkidsalv migstatus pct_inr* nbitems  ///
												sat5 sex5 hhincnet enrol pa26 pa27 pa28 np reldur cob hc5h1 moves sep2) nol																		
	
	drop if _merge==1														// drop temporary dropouts wave 6										
	drop if _merge==2														// drop respondents who withdrew permission to be re-contacted 
	drop _merge
	
	** Dependent variables
	
	* Contact
	gen pcontact=erg									
	recode pcontact 1 2 3 13 14 =0 	4 5 7 8 9 10 11 12 15 17 	33=1	
	tab pcontact, m

	* Cooperation
	gen pcoop=erg
	recode pcoop 1 2 3 13 14=. 	4 5 7 8 9 10 11 12 15 17=0 	33=1 	
	tab pcoop, m
	
	* Participation
	gen presponse=erg
	recode presponse 33=1 else=0
	tab presponse, m
	
	gen waveb=7
	
	save "wave7.dta", replace	
	

** Pooled data set 
use wave1, clear											
append using wave3 wave4 wave5 wave6 wave7, nol									
	
label def waveb 1"Wave 1" 3" Waves 2/3" 4"Waves 3/4" 5"Waves 4/5" 6"Waves 5/6" 7"Waves 6/7"
label val waveb waveb
	
describe, short															  			
sort id waveb


** Drop Person-Years after temporary dropout
bysort id (wave): gen last = 1  if _n==_N //last person-year

cap drop help
gen help=0
bysort id (waveb): replace help=1 if waveb==1 & waveb[_n+1]!=3 & last!=1
bysort id (waveb): replace help=1 if waveb==3 & waveb[_n+1]!=4 & last!=1
bysort id (waveb): replace help=1 if waveb==4 & waveb[_n+1]!=5 & last!=1
bysort id (waveb): replace help=1 if waveb==5 & waveb[_n+1]!=6 & last!=1
bysort id (waveb): replace help=1 if waveb==6 & waveb[_n+1]!=7 & last!=1

bysort id (waveb): gen help_temp = sum(help==1)
bysort id (waveb): replace help_temp=0 if help==1 & help_temp==1

*br id waveb pcoop pcontact help last help help_temp

tab help_temp, m
drop if help_temp>=1

cap drop help* 
cap drop last

tab pcontact waveb, m
tab pcoop waveb, m							
tab presponse waveb, m
	
	
	
*******************************************
***     	DEPENDENT VARIABLES			***
*******************************************

*** Dependent Variable: Dummy contact 
label var pcontact "Contact wave t"
label def pcontact 0 "0 noncontact " 1 "1 contact"
label val pcontact pcontact 

*** Dependent Variable: Dummy response 
label var pcoop "Cooperation wave t"
label def pcoop 0 "0 Non cooperation " 1 "1 Cooperation"
label val pcoop pcoop 

*** Dependent Variable: Dummy response 
label var presponse "Participation wave t"
label def presponse 0 "0 No Participation " 1 "1 Participation"
label val presponse presponse 


	
************************************************************
***     LAGGED EXPLANATORY VARIABLES  based on wave t-1	 ***
************************************************************

** Separation 
tab hpsep, m
label var hpsep "Separation"

* Checks
* anchor person indicated partnership in previous wave, no partnership in current wave and no separation 
tab hpsep, m
tab wave hpsep, row
gen ind=0
bysort id (wave): replace ind=1 if hp[_n-1]==1 & hp==0 & hpsep==0 & pid[_n-1]!=. & pid==.
bysort id: egen ind_long=max(ind)
tab ind relstat, m
tab waveb ind, m
*tab reldur ind, m
*br id pid waveb hp hpsep ind if ind_long==1

* anchor persons with different partner as in previous wave
gen newp=0
bysort id (wave): replace newp=1 if pid!=pid[_n-1] & pid!=. & pid[_n-1]!=. 
bysort id: egen newp_long=max(newp)	

tab waveb newp , m
count if newp==1 & hpsep==0		
bysort waveb: tab newp hpsep, m

sort id waveb
*br id waveb pid hp hpsep newp if newp_long==1


** Gender
tab sex_gen, m
recode sex_gen (-4=.)
gen woman = sex_gen-1
label var woman "Female"


** Age
tab age, m
label var age "Age"


** Cohort
tab cohort, m
label def cohort 1 "Birth cohort 1991-1993" 2 "Birth cohort 1981-1983" 3 "Birth cohort 1971-1973"
label value cohort cohort


** Employment status
tab lfs, m
generate workedu=.
	replace workedu=1 if inlist(lfs,5,8,9,12 )      	// Full-time employed, self-employed, and vocational training
	replace workedu=2 if lfs==1							// In education
	replace workedu=3 if inlist(lfs,10,11,13)           // Part-time employed
	replace workedu=4 if inlist(lfs,2,3,6,7)            // Out of labor force
	replace workedu=5 if inlist(lfs,4)				   	// Unemployed

tab workedu lfs, m                                                                                            
label define worklbl 1 "Full-time" 2 "In education" 3 "Part-time" 4 "Out of labor force" 5 "Unemployed"
label value workedu worklbl


** Years of Education
tab yeduc, m

* Adding years of education if school==0 "currently enrolled" 
/*
1  "Hauptschule" ///                
2  "Realschule" ///                 
3  "Gymnasium" ///                  
4  "Gesamtschule" ///               
5  "Sonderschule / Frderschule" ///
6  "other school" ///
7  "Kolleg, 2.Bildungsweg" ///
9  "general school w/o further information" ///
11 "vocational training (berufl. Ausbildung)" ///
12 "Fachschule" ///
13 "Berufsakademie" ///
14 "university, FH" ///
15 "Berufsvorbereitende Manahme" ///
16 "other education" ///
19 "vocational school w/o further information"    
*/

tab enrol yeduc if yeduc==0

gen enrolmod=enrol
recode enrolmod (1 4/6 9 15 16 = 9)   (2 7 11 19 = 10)    (12 13 = 12)    (3 14 = 13)    
  
gen yeducmod=yeduc	
recode yeducmod (-7=.)
replace yeducmod=enrolmod if yeducmod==0
tab yeducmod, m
recode yeducmod (1.5 3 =8)

label var yeducmod "Years of education"

gen yeduc10 = yeducmod/10
label var yeduc10 "Years of education/10"


** Migration status
recode migstatus (-7=.)
label define miglbl 1 "Non migrant" 2 "1st generation migrant" 3 "2nd generation migrant"
label value migstatus miglbl


** Home ownership 
tab hc5h1, m

gen house=hc5h1
recode house -3=0 						// -3: no ownership							
recode house -1 -2=.					
recode house -4=0						// -4: no ownership
recode house 1 2 8=0 3/7=1
tab house, m

label var house "Home ownership"


** Relationship status 
tab relstat, m		// ---> 5 Married noncohabiting: 100 cases --> LAT
tab relstat hpsep, m
tab relstat ind, m
					
gen relstatn=.
	replace relstatn=1 if inlist(relstat,1,6,9)    & relstat>0			// Single
	replace relstatn=2 if inlist(relstat,2,5,7,10) & relstat>0			// LAT
	replace relstatn=3 if inlist(relstat,3,8,11)   & relstat>0			// Cohabiting
	replace relstatn=4 if inlist(relstat,4) 	   & relstat>0			// Married
	
label define rellbl 1 "Single" 2 "Living apart together" 3 "Cohabiting" 4 "Married"
label value relstatn rellbl
	
tab relstat relstatn, m 
tab1 relstatn*, m
tab relstatn hpsep, m

*l id pid waveb hp hpsep ind newp relstatn relstat if hpsep==0 & relstatn==1
replace relstatn=2 if hpsep==0 & relstatn==1 & hp==1 & pid!=. 


** Children 
tab nkidsalv, m
gen kidsalv= nkidsalv
recode kidsalv (-7=.) (0=0) (else=1)
tab nkidsalv kidsalv,m

label var kidsalv "Children"

tab kidsalv, m


** Item-Nonresponse
gen inrsat5=0  
recode inrsat5 (0=1) if inlist(sat5,-1,-2)
label var inrsat5 "Itemnonresponse in Satisfaction with sex. life"

gen inrsex5=0
recode inrsex5 (0=1) if inlist(sex5,-1,-2)
label var inrsex5 "Itemnonresponse in use of contraceptives"

gen inr_intim=0
recode inr_intim (0=1) if inrsat5==1 | inrsex5==1 				
label var inr_intim "Nonresponse intimate questions"

gen inr_hhinc=0
recode inr_hhinc (0=1) if hhincnet==-7
label var inr_hhinc "Nonresponse household income"


** Length of panel participation
tab wave, gen(wave)
tab1 wave*, m

cap label drop wave
label var wave "Length of panel participation" 
label def wave 1 "1 Wave" 2"2 Waves" 3" 3 Waves" 4"4 Waves" 5"5 Waves" 6"6 Waves"
label val wave wave
tab wave, m


** save full sample
save attrition_full, replace


	
**********************************************************************************
*** 	Analysis sample: Two consecutive observations & partner in wave t-2    ***
**********************************************************************************	

cap drop sample
gen sample=0

bysort id (waveb): replace sample=1 if hp[_n-1]==1  		& ((pid==pid[_n-1]) | hpsep==1)	  
bysort id (waveb): replace sample=1 if sample[_n+1]==1 & hp==1 

*br id waveb pid hp hpsep pcontact sample
tab sample, m

cap drop help
gen help=0
bysort id (waveb): replace help=1 if hpsep==1 & hp[_n-1]==0
*l id pid ehc2p* if ehc2p1==0 & hpsep==0
drop help

drop if sample==0 		// keep observation of respondents with a partner in at least wave t-2

sort id waveb


* Checks
bysort id (waveb): gen pynr = _n   				// person-years numbered consecutively (within person)
cap drop pycount
bysort id: gen pycount = _N 

bysort pid (waveb): gen pynrpid = _n   if pid!=.
cap drop pycountpid
bysort pid: gen pycountpid = _N 	  if pid!=.

* generate indicator first person year in relationship
cap drop first
bysort pid (waveb): gen 	first = 1 if pynrpid==1 										 // first person-year relationship
forvalues x=1/5{
local plus1=`x'+1
bysort id (waveb): replace first = 1 if hp==1 ///
				   & hpsep[_n-`x']==1 & pid==pid[_n-`plus1'] & pid!=. & pid[_n-`plus1']!=.   // respondents with same partner (same pid)
}

gen help=0
bysort id (waveb): replace help=1 if hp[_n-1]==0 & first!=1		// ok
cap drop help*

sort id waveb 
*br id pid waveb age sample hp hpsep newp

* Check if hpsep==1 in first episode
l id age sample hp hpsep if hpsep==1 & pynr==1	// o.k.
count if hpsep==1 & pynr==1		// o.k.

* Check indicator first & newp
l id pid waveb hp hpsep first if newp==1 & first==0   // o.k. 
	
* New partner and separation former partner reported in same wave	
tab hpsep hp, m
tab sep2 hpsep if hp==1 & hpsep==1, m
*bysort waveb: tab sep2 hpsep if hp==1, m			// questions on separation

* Check: either in relationship or separated
gen help=0
replace help=1 if hpsep==0 & hp==0
tab waveb help,m 
tab help ind, m
bysort id (waveb): egen help_long=max(help)
*br id pid waveb hp hpsep sample ind newp ehc6p1 ehc2p1 if help_long==1
replace hp=1 if help==1 & ind==0		// 1 case
cap drop help*

sort id waveb


********************************************************************
***     LAGGED EXPLANATORY VARIABLES based on waves t-2 and t-1	 ***
********************************************************************

** Change employment status 
cap drop pynr
bysort id (waveb): gen pynr = _n   				// person-years numbered consecutively (within person)
gen changework=.
bysort id (wave): replace changework=0 if !inlist(workedu,.,.a) 	& waveb!=1	
bysort id (wave): replace changework=1 if workedu[_n-1]!=workedu	& pynr!=1 & workedu!=. & workedu[_n-1]!=.

label var changework "Change employment status"
tab wave changework, m
tab changework workedu, m


** Moves 
tab waveb moves, m
tab moves, m
tab waveb moves, m

label var moves "Moved"


** LAT & cohabiting
gen latattr=.
bysort id (wave): replace latattr=1 if relstatn==2 					& hpsep==0 
bysort id (wave): replace latattr=1 if relstatn[_n-1]==2 			& hpsep==1
bysort id (wave): replace latattr=0 if inlist(relstatn,3,4) 		& hpsep==0 
bysort id (wave): replace latattr=0 if inlist(relstatn[_n-1],3,4)	& hpsep==1 

tab latattr, m

label var latattr "Living apart together"

gen cohabattr=.
bysort id (wave): replace cohabattr=1 if inlist(relstatn,3,4) 		& hpsep==0 
bysort id (wave): replace cohabattr=1 if inlist(relstatn[_n-1],3,4) & hpsep==1 
bysort id (wave): replace cohabattr=0 if relstatn==2 				& hpsep==0 
bysort id (wave): replace cohabattr=0 if relstatn[_n-1]==2 			& hpsep==1 

tab cohabattr, m

label var cohabattr "Cohabiting"

tab latattr cohabattr, m
tab waveb latattr, row
*br id pid waveb hp hpsep relstatn cohabattr latattr first 


** Duration of relationship
tab reldur, m
tab reldur hpsep, m
tab reldur waveb, m

mvdecode reldur, mv(-7=. \ -3=.a)   //code missing values, extra code -3 Does not apply -4 Filter error
gen reldur_y=round(reldur/12,1)

gen reldurattr=. 
bysort id (wave): replace reldurattr=reldur			if hpsep==0 
bysort id (wave): replace reldurattr=reldur[_n-1] 	if hpsep==1 
tab reldurattr, m
*br id pid waveb hp hpsep reldur reldurattr 

gen reldur_yattr=round(reldurattr/12,1)
tab reldur_yattr, m

label var reldur_yattr "Duration of relationship"


** Subjective instability of relationship 
count if pa26==1 & pa27!=1
count if pa26==1 & pa28!=1

egen instab=anycount(pa26 pa27 pa28), values(1)
egen help=anymatch(pa26 pa27 pa28), values(-7/-1)
replace instab=. if help==1
drop help
tab instab, m
recode instab (1/3=1)

gen instabattr=. 
bysort id (wave): replace instabattr=instab			if hpsep==0 
bysort id (wave): replace instabattr=instab[_n-1] 	if hpsep==1 
tab instabattr, m
tab age instabattr, m		



*** Save data set  
keep  id pid wave* pcoop pcontact presponse age* cohort woman workedu* changework* yeduc* kidsalv moves house inr* nbitems pct_inr ///
		hpsep hp relstatn lat* cohab* reldur* sample* migstatus instabattr pa26 pa27 pa28
		
sort id waveb 
compress
save attrition_restr.dta, replace



*** Final cleaning
forvalues x=3/7{
	cap erase wave`x'.dta
	cap erase Bruttoband_Welle`x'red.dta
}
cap erase wave1.dta

forvalues x=1/7{
	cap erase anchor`x'p.dta
	cap erase biomob`x'.dta
}

